//	Critical Mass Be
//	started 12/7/1997
//	Hamish Carr

#pragma once

class CMBoard;								//	forward declaration

#define N_ROWS 5
#define N_COLS 6

#include "CMassView.h"

#define N_CELLS 30
#define H_STEP 1
#define V_STEP 8
#define ARRAY_SIZE 56
#define RED_PLAYER -1
#define NEITHER_PLAYER 0
#define BLUE_PLAYER 1
#define RED_BOOM -6
#define BLUE_BOOM 6
#define RED_WIPED_OUT 10000					//	arbitrary value marking blue success
#define BLUE_WIPED_OUT -10000					//	arbitrary value marking red success
#define ILLEGAL_RED 10001					//	arbitrary value for illegal move
#define ILLEGAL_BLUE -10001					//	arbitrary value for illegal move

static int redExplosions[ARRAY_SIZE] = 		//	array representing "full" red cells
		{ 0, 0, 0, 0, 0, 0, 0, 0,
		  0,-2,-3,-3,-3,-3,-2, 0,
		  0,-3,-4,-4,-4,-4,-3, 0,
		  0,-3,-4,-4,-4,-4,-3, 0,
		  0,-3,-4,-4,-4,-4,-3, 0,
		  0,-2,-3,-3,-3,-3,-2, 0,
		  0, 0, 0, 0, 0, 0, 0, 0};

static int blueExplosions[ARRAY_SIZE] =		//	array representing "full" blue cells
		{ 0, 0, 0, 0, 0, 0, 0, 0,
		  0, 2, 3, 3, 3, 3, 2, 0,
		  0, 3, 4, 4, 4, 4, 3, 0,
		  0, 3, 4, 4, 4, 4, 3, 0,
		  0, 3, 4, 4, 4, 4, 3, 0,
		  0, 2, 3, 3, 3, 3, 2, 0,
		  0, 0, 0, 0, 0, 0, 0, 0};

static int cellWeights[ARRAY_SIZE] = 			//	array holding weighting factors
		{ 0, 0, 0, 0, 0, 0, 0, 0,
		  0, 4, 2, 2, 2, 2, 4, 0,
		  0, 2, 1, 1, 1, 1, 2, 0,
		  0, 2, 1, 1, 1, 1, 2, 0,
		  0, 2, 1, 1, 1, 1, 2, 0,
		  0, 4, 2, 2, 2, 2, 4, 0,
		  0, 0, 0, 0, 0, 0, 0, 0};

//class CMassView;							//	forward declaration

class CMBoard								//	class encapsulating game board
	{
	public:
	int bombs[ARRAY_SIZE];					//	the array holding the bombs
										//	note:  +ve is blue, -ve is black
	int *explosionQueue[N_CELLS];				//	queue for tracking explosions

	public:
	CMBoard();							//	default constructor
	CMBoard(CMBoard &theBoard);				//	copy constructor

	int Bombs(int r, int c);					//	accessor for bombs array
	
	void AddRedBomb(int r, int c);			//	routine to add a red bomb
	void AddBlueBomb(int r, int c);			//	routine to add a blue bomb
	
	bool HasRedWon();						//	routine to test for red victory
	bool HasBlueWon();						//	routine to test for blue victory
	
	void ExplodeRed();						//	routine to blow up red bombs
	void ExplodeBlue();						//	routine to blow up blue bombs
	
	//	versions that show results - for debug & display	
	// 	note the dummy flag - this is to force overloading
	//	later, it will be used to pass a BView
	void ExplodeRed(CMassView &display);		//	routine to show red explosions
	void ExplodeBlue(CMassView &display);		//	routine to show blue explosions

	void MoveRed(int r, int c);				//	execute a red move
	void MoveBlue(int r, int c);				//	execute a blue move
	
	//	versions that show results - for debug & display	
	void MoveRed(int r, int c, CMassView &display);	//	routine to show red move
	void MoveBlue(int r, int c, CMassView &display);	//	routine to show blue move
	
	int Evaluate(bool isFirstTurn = false);		//	evaluate the board's value 
	bool IsLegalMove(int r, int c, int player);	//	test to see if a move is legal

	void Copy(CMBoard &original);				//	copy a board
	}; // end of class CMBoard
